#!/usr/bin/python3

 
from LinuxChangelogs import Slackware

data = {}
for release, info in Slackware.RELEASES.items():
	data[release] = {}
	for port in info["ports"]:
		data[release][port] = []
		chunks = Slackware.open_changelog_file(release, port)
		for x in chunks:
			datestamp, chunk = Slackware.parse_chunk(x)
			if chunk is not None:
				for line in chunk:
					data[release][port].append(line)
		

for x in data["12.0"]["x86"]:
	print(x)
